
#define F_CPU 16000000UL
#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>

void pwm_enable()
{
    TCCR1A|=(1<<COM1A1)|(1<<COM1B1)|(1<<WGM11);        //NON Inverted PWM
    TCCR1B|=(1<<WGM13)|(1<<WGM12)|(1<<CS11)|(1<<CS10);
    ICR1=4999;
}

uint16_t adc_read(uint8_t channel)
{
    // select adc channel
    ADMUX &= 0xf0;
    ADMUX |= channel;

    // start conversion
    ADCSRA |= _BV(ADSC);

    // wait for completion
    while (!(ADCSRA & _BV(ADIF)));

    // acknowledge
    ADCSRA |= _BV(ADIF);

    return ADC;
}

void adc_enable()
{
    // prescaler 128, clock 16Mhz -> 125KHz
    ADCSRA |= _BV(ADPS2) | (0 << ADPS1) | _BV(ADPS0);
    // Aref = Vcc
    ADMUX = _BV(REFS0);
    // enable ADC
    ADCSRA |= _BV(ADEN);
}

int main()
{
    // set ports D & B to all outputs
    DDRD = 0xff;
    DDRB = 0xff;
    pwm_enable();

    uint16_t adc_result;
    while (1)
    {
        adc_result = adc_read(0);

        OCR1A = 2000;
        OCR1B = 2000;
        _delay_ms(1000);
    }
}

SIGNAL (TIMER1_COMPA_vect)
{
    return;
}